<?php

namespace App\Http\Controllers;

use App\Models\dati;
use Illuminate\Http\Request;
use Symfony\Component\VarDumper\Cloner\Data;
use Yajra\DataTables\Facades\DataTables;


class DatiController extends Controller
{
    public function index(Request $request){
        $Datis = Dati::all();

        return view('welcome', ['Datis' => $Datis]);
    }

    public function ajaxDati(Request $request){
        $Datis = Dati::query();

        return DataTables::eloquent($Datis)
            ->toJson();
    }

    public function ajaxPost(Request $request) {
        $updating = $request->id !== null;
        $success = true;
        $message = "";

        if (!$updating) {
            $Dati = new Dati();
            $Dati->create($request->all());
        } else {
            $Dati = Dati::find($request->id);
            $Dati->update($request->all());
            $Dati->save();
        }

        return [
            'success' => $success,
            'message' => $message,

        ];
    }

    public function ajaxDestroy(Request $request)
    {
        $success = true;
        $message = "";

        $Dati = Dati::find($request->id);
        $Dati->delete();

        return [
            'success' => $success,
            'message' => $message,


        ];
    }
}


